/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core.other;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.abnormals_core.core.util.TradeUtil;
import com.minecraftabnormals.autumnity.common.block.RedstoneJackOLanternBlock;
import com.minecraftabnormals.autumnity.common.entity.passive.SnailEntity;
import com.minecraftabnormals.autumnity.core.other.AutumnityCompat;
import com.minecraftabnormals.autumnity.core.other.AutumnityCriteriaTriggers;
import com.minecraftabnormals.autumnity.core.other.JackOLanternHelper;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBiomes;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEffects;
import com.minecraftabnormals.autumnity.core.registry.AutumnityItems;
import com.minecraftabnormals.autumnity.core.registry.AutumnityStructures;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autumnity")
public class AutumnityEvents {
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(UUID.fromString("98D5CD1F-601F-47E6-BEEC-5997E1C4216F"), "Knockback modifier", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Entity entity = event.getEntity();
            if (entity instanceof PillagerEntity) {
                ((CreatureEntity)entity).field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), SnailEntity.class, true));
            } else if (entity instanceof MooshroomEntity) {
                ((CreatureEntity)entity).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)entity, SnailEntity.class, 16.0f, 1.25, 1.6, EntityPredicates.field_188444_d::test));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        IWorld world = event.getWorld();
        LivingEntity livingentity = event.getEntityLiving();
        if (livingentity instanceof ZombieEntity || livingentity instanceof AbstractSkeletonEntity) {
            if (livingentity.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() && DataUtil.matchesKeys((ResourceLocation)world.func_226691_t_(livingentity.func_233580_cy_()).getRegistryName(), (RegistryKey[])new RegistryKey[]{AutumnityBiomes.PUMPKIN_FIELDS.getKey()}) && world.func_201674_k().nextFloat() < 0.05f) {
                livingentity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Blocks.field_196625_cS));
                ((MobEntity)livingentity).func_184642_a(EquipmentSlotType.HEAD, 0.0f);
            }
        } else if (livingentity instanceof CatEntity && world instanceof ServerWorld && ((ServerWorld)world).func_241112_a_().func_235010_a_(livingentity.func_233580_cy_(), true, (Structure)AutumnityStructures.MAPLE_WITCH_HUT.get()).func_75069_d()) {
            ((CatEntity)livingentity).func_213422_r(10);
            ((CatEntity)livingentity).func_110163_bv();
        }
    }

    @SubscribeEvent
    public static void onSnailShellChestplateSneak(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        entity.func_110148_a(Attributes.field_233820_c_).func_111124_b(KNOCKBACK_MODIFIER);
        if (entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == AutumnityItems.SNAIL_SHELL_CHESTPLATE.get() && entity.func_225608_bj_()) {
            entity.func_110148_a(Attributes.field_233820_c_).func_233767_b_(KNOCKBACK_MODIFIER);
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        ItemStack itemstack = event.getItemStack();
        Item item = itemstack.func_77973_b();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!player.func_175149_v()) {
            if (item == AutumnityItems.FOUL_BERRIES.get() && ModList.get().isLoaded("berry_good")) {
                event.setUseItem(Event.Result.DENY);
            } else if (player.func_70644_a((Effect)AutumnityEffects.FOUL_TASTE.get()) && player.func_71043_e(false) && (block instanceof CakeBlock || ModList.get().isLoaded("atmospheric") && block == AutumnityCompat.YUCCA_GATEAU)) {
                if (player.func_71024_bL().func_75116_a() < 19) {
                    player.func_71024_bL().func_75122_a(1, 0.0f);
                }
                AutumnityEvents.updateFoulTaste(player);
            }
        }
    }

    @SubscribeEvent
    public static void onFoulBerriesEaten(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemstack = event.getItem();
        if (event.getEntityLiving().func_70644_a((Effect)AutumnityEffects.FOUL_TASTE.get()) && event.getEntityLiving() instanceof PlayerEntity && itemstack.func_222117_E()) {
            Item item = itemstack.func_77973_b();
            Food food = item.func_219967_s();
            boolean flag = true;
            if (item instanceof SuspiciousStewItem) {
                CompoundNBT compoundnbt = itemstack.func_77978_p();
                if (compoundnbt != null && compoundnbt.func_150297_b("Effects", 9)) {
                    ListNBT listnbt = compoundnbt.func_150295_c("Effects", 10);
                    for (int i = 0; i < listnbt.size(); ++i) {
                        CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                        Effect effect = Effect.func_188412_a((int)compoundnbt1.func_74771_c("EffectId"));
                        if (effect != AutumnityEffects.FOUL_TASTE.get()) continue;
                        flag = false;
                        break;
                    }
                }
            } else {
                for (Pair pair : food.func_221464_f()) {
                    if (((EffectInstance)pair.getFirst()).func_188419_a() != AutumnityEffects.FOUL_TASTE.get()) continue;
                    flag = false;
                    break;
                }
            }
            if (flag) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                int i = food.func_221466_a();
                int j = i == 1 ? i : (int)((float)i * 0.5f);
                player.func_71024_bL().func_75122_a(j, 0.0f);
                AutumnityEvents.updateFoulTaste(player);
            }
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(5, ((Block)AutumnityBlocks.MAPLE_SAPLING.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(5, ((Block)AutumnityBlocks.YELLOW_MAPLE_SAPLING.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(5, ((Block)AutumnityBlocks.ORANGE_MAPLE_SAPLING.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(5, ((Block)AutumnityBlocks.RED_MAPLE_SAPLING.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(4, ((Block)AutumnityBlocks.SNAIL_SLIME.get()).func_199767_j(), 1, 5, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.field_221156_f, (int)2, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(2, (Item)AutumnityItems.FOUL_BERRIES.get(), 16, 12, 10)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.field_221153_c, (int)3, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(((Block)AutumnityBlocks.TURKEY.get()).func_199767_j(), 6, 1, 16, 20)});
    }

    @SubscribeEvent
    public static void onMakeJackOLantern(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack = event.getItemStack();
        Block jackolantern = JackOLanternHelper.getJackOLantern(itemstack.func_77973_b());
        if (jackolantern != null) {
            Direction direction1;
            Direction direction;
            boolean flag1;
            World world = event.getWorld();
            BlockPos blockpos = event.getPos();
            BlockState blockstate = event.getWorld().func_180495_p(event.getPos());
            PlayerEntity player = event.getPlayer();
            boolean flag = !player.func_184614_ca().doesSneakBypassUse((IWorldReader)world, blockpos, player) || !player.func_184592_cb().doesSneakBypassUse((IWorldReader)world, blockpos, player);
            boolean bl = flag1 = player.func_226563_dT_() && flag;
            if (blockstate.func_177230_c() == Blocks.field_196625_cS && !flag1 && (direction = event.getFace()) == (direction1 = (Direction)blockstate.func_177229_b((Property)CarvedPumpkinBlock.field_196359_a))) {
                if (!world.field_72995_K) {
                    BlockState blockstate1 = jackolantern == AutumnityBlocks.REDSTONE_JACK_O_LANTERN.get() ? (BlockState)jackolantern.func_176223_P().func_206870_a((Property)RedstoneJackOLanternBlock.LIT, (Comparable)Boolean.valueOf(world.func_175640_z(blockpos))) : jackolantern.func_176223_P();
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)direction1);
                    world.func_180501_a(blockpos, blockstate2, 11);
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                }
                player.func_184609_a(event.getHand());
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        LivingEntity livingentity = event.getEntityLiving();
        EffectInstance effect = event.getPotionEffect();
        EffectInstance extension = livingentity.func_70660_b((Effect)AutumnityEffects.EXTENSION.get());
        if (extension != null && effect.func_188419_a() != AutumnityEffects.EXTENSION.get()) {
            effect.func_199308_a(new EffectInstance(effect.func_188419_a(), effect.func_76459_b() + 300 + 300 * (extension.func_76458_c() + 1), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f()));
        }
    }

    public static void updateFoulTaste(PlayerEntity player) {
        EffectInstance effect = player.func_70660_b((Effect)AutumnityEffects.FOUL_TASTE.get());
        player.func_195063_d((Effect)AutumnityEffects.FOUL_TASTE.get());
        if (effect.func_76458_c() > 0) {
            player.func_195064_c(new EffectInstance((Effect)AutumnityEffects.FOUL_TASTE.get(), effect.func_76459_b(), effect.func_76458_c() - 1));
        }
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            if (!player.func_130014_f_().func_201670_d()) {
                AutumnityCriteriaTriggers.CURE_FOUL_TASTE.trigger(serverplayerentity);
            }
        }
    }
}

